<?php

namespace Drupal\Tests\commerce_paynow\Unit;

use Drupal\commerce_payment\PaymentMethodTypeManager;
use Drupal\commerce_payment\PaymentTypeManager;
use Drupal\commerce_paynow\Plugin\Commerce\PaymentGateway\Paynow;
use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Tests\commerce_paynow\PaynowTestsTrait;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\IgnoreDeprecations;
use Symfony\Component\HttpFoundation\HeaderBag;
use Symfony\Component\HttpFoundation\Request;

/**
 * Unit tests for the Paynow payment gateway plugin.
 */
#[Group('commerce_paynow')]
#[IgnoreDeprecations]
class PaynowUnitTest extends UnitTestCase {

  use PaynowTestsTrait;

  /**
   * The payment gateway plugin under test.
   *
   * @var \Drupal\commerce_paynow\Plugin\Commerce\PaymentGateway\Paynow
   */
  protected $plugin;

  /**
   * Mock entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $entityTypeManager;

  /**
   * Mock payment type manager.
   *
   * @var \Drupal\commerce_payment\PaymentTypeManager|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $paymentTypeManager;

  /**
   * Mock payment method type manager.
   *
   * @var \Drupal\commerce_payment\PaymentMethodTypeManager|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $paymentMethodTypeManager;

  /**
   * Mock time service.
   *
   * @var \Drupal\Component\Datetime\TimeInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $time;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->entityTypeManager = $this->createMock(EntityTypeManagerInterface::class);
    $this->paymentTypeManager = $this->createMock(PaymentTypeManager::class);
    $this->paymentMethodTypeManager = $this->createMock(PaymentMethodTypeManager::class);
    $this->time = $this->createMock(TimeInterface::class);

    $configuration = [
      'api_key' => self::$apiKey,
      'signature_key' => self::$signatureKey,
      'environment' => self::$environment,
      'application_name' => self::$applicationName,
    ];

    $this->plugin = new Paynow(
      $configuration,
      'paynow',
      [],
    );
  }

  /**
   * Tests request headers extraction.
   */
  public function testGetRequestHeaders() {
    $reflection = new \ReflectionClass($this->plugin);
    $method = $reflection->getMethod('getRequestHeaders');
    $method->setAccessible(TRUE);

    $request = $this->createMock(Request::class);
    $headerBag = $this->createMock(HeaderBag::class);

    $headerBag->expects($this->once())
      ->method('all')
      ->willReturn([
        'signature' => ['test-signature'],
        'content-type' => ['application/json'],
      ]);

    $request->headers = $headerBag;

    $result = $method->invokeArgs($this->plugin, [$request]);

    $expected = [
      'signature' => 'test-signature',
      'content-type' => 'application/json',
    ];

    $this->assertEquals($expected, $result);
  }

}
