# Commerce PayPay

Provides PayPay payment gateway integration for Drupal Commerce. PayPay is a popular mobile payment service in Japan, allowing customers to pay using QR codes.

## Features

- **QR Code Payment Flow**: Generates dynamic QR codes for customer payments
- **Authorization and Capture**: Support for both immediate capture and delayed capture payment workflows
- **Refund Support**: Full and partial refund capabilities
- **Webhook Integration**: Real-time payment status updates via webhook notifications
- **Sandbox Testing**: Toggle between production and sandbox environments

## Requirements

- Drupal 11.0 or higher
- Drupal Commerce 3.2.x
- PayPay PHP SDK (`paypayopa/php-sdk`)

## Installation

```bash
composer require drupal/commerce_paypay
drush en commerce_paypay
```

## Configuration

1. Navigate to **Commerce → Configuration → Payment gateways**
2. Add a new payment gateway and select "PayPay"
3. Configure your PayPay credentials:
   - **API Key**
   - **API Secret**
   - **Merchant ID**
   - **Production mode**: Check for live payments, uncheck for sandbox testing
4. Select payment mode:
   - **Authorization**: Reserve funds, capture later (two-step process)
   - **Capture**: Charge immediately (one-step process)
