<?php

namespace Drupal\commerce_payplug\Services;

use Payplug\Notification;
use Payplug\Payment;
use Payplug\Payplug;
use Payplug\Refund;

/**
 * PayPlug encapsulation service class.
 *
 * This class can be injected in requiring class, thus allow PayPlug service
 * unit/functional testing.
 *
 * @group commerce_payplug
 */
class PayPlugService implements PayPlugServiceInterface {

  /**
   * The PayPlug API key.
   *
   * @var string
   */
  protected $apiKey;

  /**
   * {@inheritdoc}
   */
  public function setApiKey($api_key) {
    $this->apiKey = $api_key;
  }

  /**
   * {@inheritdoc}
   */
  public function createPayPlugPayment(array $data, ?Payplug $payplug = NULL) {
    Payplug::init([
      'secretKey' => $this->apiKey,
    ]);
    $payment = Payment::create($data, $payplug);
    return $payment;
  }

  /**
   * {@inheritdoc}
   */
  public function createPayPlugRefund($payment, array $data, ?Payplug $payplug = NULL) {
    Payplug::init([
      'secretKey' => $this->apiKey,
    ]);
    $refund = Refund::create($payment, $data, $payplug);
    return $refund;
  }

  /**
   * {@inheritdoc}
   */
  public function treatPayPlugNotification($notification, $authentication = NULL) {
    Payplug::init([
      'secretKey' => $this->apiKey,
    ]);
    $resource = Notification::treat($notification, $authentication = NULL);
    return $resource;
  }

}
