<?php

namespace Drupal\commerce_payplug_tests\Services;

use Drupal\commerce_payplug\Services\PayPlugServiceInterface;
use Drupal\Component\Serialization\Json;
use Drupal\Core\Url;
use Payplug\Payplug;
use Payplug\Resource\APIResource;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Testing PayPlug encapsulation service class.
 *
 * This class defines some mock methods for testing purpose.
 *
 * @group commerce_payplug
 */
class PayPlugTestService implements PayPlugServiceInterface {

  /**
   * The Payplug payment attributes.
   *
   * @var array
   */
  const PAYLOAD = [
    'is_live' => FALSE,
    'save_card' => FALSE,
    'is_paid' => TRUE,
    'metadata' => [
      'order_id' => 1,
    ],
    'card' => [
      'brand' => NULL,
      'id' => NULL,
      'metadata' => NULL,
      'exp_year' => 2018,
      'last4' => '4242',
      'exp_month' => 1,
      'country' => 'US'
    ],
    'amount_refunded' => 0,
    'is_refunded' => FALSE,
    'failure' => NULL,
    'created_at' => 1486758204,
    'hosted_payment' => [
      'cancel_url' => 'http://fake.url',
      'payment_url' => 'http://fake.url',
      'paid_at' => 1486758217,
      'return_url' => 'http://fake.url',
    ],
    'is_3ds' => TRUE,
    'customer' => [
      'address2' => NULL,
      'email' => 'test@test.com',
      'address1' => NULL,
      'first_name' => 'session',
      'city' => NULL,
      'last_name' => 'test',
      'postcode' => NULL,
      'country' => NULL,
    ],
    'id' => 'pay_4ZioFZ88LVGfGFe2AKpXp6',
    'notification' => [
      'url' => 'http://fake.url',
      'response_code' => NULL,
    ],
    'object' => 'payment',
    'amount' => 2999,
    'currency' => 'USD',
  ];

  /**
   * {@inheritdoc}
   */
  public function createPayPlugPayment(array $data, ?Payplug $payplug = NULL) {
    $payment = json_decode(Json::encode(self::PAYLOAD));
    $payment->hosted_payment->payment_url = Url::fromRoute('commerce_payplug_tests.fake_payplug', [], ['absolute' => TRUE])->toString();
    return $payment;
  }

  /**
   * Fakes a call to Payplug website.
   */
  public function payplug() {
    // Simulate a POST request from PayPlug to the notify route.
    /** @var \GuzzleHttp\Client $client */
    $client = \Drupal::httpClient();
    $client->post(Url::fromRoute('commerce_payment.notify', ['commerce_payment_gateway' => 'offsite_payplug'], ['absolute' => TRUE])->toString(), [
      'json' => self::PAYLOAD,
    ]);

    // Redirect to success payment page.
    return new RedirectResponse(Url::fromRoute('commerce_payment.checkout.return', [
      'commerce_order' => 1,
      'step' => 'payment',
    ], ['absolute' => TRUE])->toString());
  }

  /**
   * {@inheritdoc}
   */
  public function setApiKey($api_key) {
    // @todo Implement setApiKey() method.
  }

  /**
   * {@inheritdoc}
   */
  public function createPayPlugRefund($payment, array $data, ?Payplug $payplug = NULL) {
    // @todo Implement createPayPlugRefund() method.
  }

  /**
   * {@inheritdoc}
   */
  public function treatPayPlugNotification($notification, $authentication = NULL) {
    return APIResource::factory(Json::Decode($notification));
  }

}
