# Commerce PayUMoney

A Drupal Commerce payment method module that provides PayUMoney payment gateway integration for Drupal 11.

## Overview

This module provides integration between Drupal Commerce and PayUMoney, enabling Indian merchants to accept online payments through PayUMoney's secure payment gateway.

## Features

- **Secure Payment Processing**: Integration with PayUMoney's secure payment gateway
- **Multiple Payment Methods**: Support for Credit Cards, Debit Cards, Net Banking, and Wallets
- **Test and Live Modes**: Comprehensive support for both testing and production environments
- **Transaction Logging**: Complete transaction logging and audit trail
- **Webhook Support**: Real-time payment notifications and status updates
- **Hash Verification**: Secure hash verification for payment authenticity
- **Drupal 11 Ready**: Fully compatible with Drupal 11 and modern PHP versions

## Requirements

### System Requirements
- Drupal: ^10.1 || ^11
- PHP: >= 8.1
- Extensions: OpenSSL, Hash

### Module Dependencies
- Commerce Core (`commerce:commerce`)
- Commerce Payment (`commerce:commerce_payment`)

## Installation

### Via Composer (Recommended)
```bash
composer require drupal/commerce_payumoney
drush en commerce_payumoney
```

### Manual Installation
1. Download the module and place it in `/modules/contrib/commerce_payumoney`
2. Enable the module: `drush en commerce_payumoney`

## Configuration

### 1. PayUMoney Account Setup
1. Register for a PayUMoney merchant account at https://www.payumoney.com/
2. Obtain your Merchant Key and Salt from the PayUMoney dashboard
3. Configure your Return URLs in PayUMoney dashboard:
   - Success URL: `https://yourdomain.com/payment/success/payumoney`
   - Failure URL: `https://yourdomain.com/payment/failure/payumoney`
   - Notify URL: `https://yourdomain.com/payment/notify/payumoney`

### 2. Module Configuration
1. Navigate to Commerce → Configuration → Payment gateways
2. Click "Add payment gateway"
3. Select "PayUmoney Redirect" as the plugin
4. Configure the following settings:

#### Required Settings
- **Label**: Display name for the payment method
- **PayUMoney Key**: Your merchant key from PayUMoney
- **PayUMoney Salt**: Your merchant salt from PayUMoney
- **Mode**: Test or Live environment

#### Optional Settings
- **Service Provider**: Choose between 'payu_paisa' (default) or leave empty for test

### 3. Gateway URLs
The module automatically configures these URLs:
- **Test URL**: `https://test.payu.in/_payment`
- **Live URL**: `https://secure.payu.in/_payment`

## Usage

### For Customers
1. Select PayUMoney as payment method during checkout
2. Click "Complete order" to proceed to payment
3. Get redirected to PayUMoney's secure payment page
4. Complete payment using preferred method
5. Return to your site with payment confirmation

### For Administrators
1. View payment transactions in Commerce → Orders
2. Check payment status and transaction details
3. Monitor transaction logs in database table `commerce_payumoney_transactions`

## Technical Implementation

### Payment Flow
1. **Order Creation**: Customer creates order and selects PayUMoney
2. **Payment Form**: Module generates secure payment form with hash
3. **Redirect**: Customer redirected to PayUMoney gateway
4. **Payment Processing**: PayUMoney processes the payment
5. **Webhook**: PayUMoney sends notification to webhook URL
6. **Verification**: Module verifies payment hash and updates order
7. **Completion**: Customer returned to success/failure page

### Hash Generation
The module implements PayUMoney's hash generation algorithm:
```php
$hash_string = $key . '|' . $txnid . '|' . $amount . '|' . $productinfo . '|' .
               $firstname . '|' . $email . '|' . $udf1 . '|' . $udf2 . '|' .
               $udf3 . '|' . $udf4 . '|' . $udf5 . '|' . $udf6 . '|' .
               $udf7 . '|' . $udf8 . '|' . $udf9 . '|' . $udf10 . '|' . $salt;
$hash = strtolower(hash('sha512', $hash_string));
```

## Security

### Hash Verification
- All payments are verified using SHA512 hash
- Hash includes transaction details and secret salt
- Failed hash verification rejects the payment

### Data Protection
- Sensitive configuration stored securely
- Transaction logs include audit trail
- No sensitive data exposed in URLs

### SSL Requirements
- HTTPS required for production use
- SSL certificates must be valid
- Webhook endpoints require secure connections

## Testing

### Test Mode Configuration
1. Set gateway mode to "Test"
2. Use PayUMoney test credentials
3. Access test gateway at `https://test.payu.in/_payment`

### Test Transactions
- Use PayUMoney's test cards and credentials
- Verify success/failure scenarios
- Check webhook notifications
- Validate transaction logging

## Troubleshooting

### Common Issues

#### Payment Hash Mismatch
- **Cause**: Incorrect key/salt configuration
- **Solution**: Verify merchant credentials in PayUMoney dashboard

#### Webhook Not Received
- **Cause**: Firewall blocking or incorrect URL
- **Solution**: Ensure webhook URL is accessible and HTTPS

#### Transaction Not Updating
- **Cause**: Database permissions or table missing
- **Solution**: Run `drush updatedb` to ensure schema is current

#### SSL Certificate Issues
- **Cause**: Invalid or self-signed certificates
- **Solution**: Use valid SSL certificates for production

### Debug Mode
Enable Drupal logging to monitor PayUMoney transactions:
```bash
drush watchdog-show --type=commerce_payumoney
```

## Support

### Documentation
- Official PayUMoney API: https://www.payumoney.com/dev-guide/
- Drupal Commerce: https://docs.drupalcommerce.org/

### Community
- Drupal.org project page: https://www.drupal.org/project/commerce_payumoney
- Issue queue: Report bugs and feature requests

## Changelog

### 4.x-1.0
- Initial Drupal 11 compatible release
- Modern dependency injection implementation
- Comprehensive webhook support
- Enhanced security features
- Full transaction logging

## License

This project is licensed under the GPL-2.0+ license - see the LICENSE.txt file for details.
