<?php

namespace Drupal\Tests\commerce_payumoney\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests PayUMoney payment gateway functionality.
 *
 * @group commerce_payumoney
 */
class PayUMoneyFunctionalTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'commerce_payumoney',
    'system',
  ];

  /**
   * Tests module installation.
   */
  public function testModuleInstallation() {
    // Test that the module is properly installed.
    $module_handler = $this->container->get('module_handler');
    $this->assertTrue($module_handler->moduleExists('commerce_payumoney'));
  }

  /**
   * Tests PayUMoney hash generation.
   */
  public function testHashGeneration() {
    // Test hash generation functionality
    $parameters = [
      'key' => 'test_key',
      'txnid' => 'test_txn_123',
      'amount' => '100.00',
      'productinfo' => 'Test Product',
      'firstname' => 'John',
      'email' => 'john@example.com',
      'udf1' => '',
      'udf2' => '',
      'udf3' => '',
      'udf4' => '',
      'udf5' => '',
      'udf6' => '',
      'udf7' => '',
      'udf8' => '',
      'udf9' => '',
      'udf10' => '',
    ];

    $salt = 'test_salt';

    // Build hash string as PayUMoney expects
    $hash_string = implode('|', [
      $parameters['key'],
      $parameters['txnid'],
      $parameters['amount'],
      $parameters['productinfo'],
      $parameters['firstname'],
      $parameters['email'],
      $parameters['udf1'],
      $parameters['udf2'],
      $parameters['udf3'],
      $parameters['udf4'],
      $parameters['udf5'],
      $parameters['udf6'],
      $parameters['udf7'],
      $parameters['udf8'],
      $parameters['udf9'],
      $parameters['udf10'],
      $salt
    ]);

    $expected_hash = strtolower(hash('sha512', $hash_string));

    // Verify hash properties
    $this->assertIsString($expected_hash);
    $this->assertEquals(128, strlen($expected_hash));
    $this->assertMatchesRegularExpression('/^[a-f0-9]{128}$/', $expected_hash);
  }

  /**
   * Tests webhook endpoints are accessible.
   */
  public function testWebhookEndpoints() {
    // Test that webhook routes are defined
    $route_provider = $this->container->get('router.route_provider');

    $routes = [
      'commerce_payumoney.notify',
      'commerce_payumoney.success',
      'commerce_payumoney.failure',
    ];

    foreach ($routes as $route_name) {
      $route = $route_provider->getRouteByName($route_name);
      $this->assertNotNull($route, "Route $route_name should exist");
    }
  }

}
