Commerce Pesapal
================

Drupal 10/11 + Commerce 3.x payment gateway for Pesapal using off-site redirect.

This version wires in the Pesapal OAuth 1.0 flow for:

* Posting transactions via PostPesapalDirectOrderV4.
* Querying transaction status via QueryPaymentStatus.

Configuration (at /admin/commerce/config/payment-gateways):

* Sandbox consumer key / secret
* Live consumer key / secret
* Mode: **Sandbox** (demo.pesapal.com) or **Live** (www.pesapal.com)
* Optional IPN URL override
* Logging verbosity: **All events**, **Errors only**, or **None**

The gateway automatically chooses the correct key/secret + endpoint based on
the Commerce gateway "Mode" selector:

* Sandbox mode -> https://demo.pesapal.com using Sandbox credentials
* Live mode    -> https://www.pesapal.com using Live credentials

Logging
-------

The module logs key events to the `commerce_pesapal` channel via an internal
`log()` helper that respects the configured logging verbosity:

* Redirect URL and mode when sending the customer to Pesapal.
* IPN callbacks and their parameters.
* Status queries to Pesapal (including raw responses).
* Creation of completed payment entities.
* Or only errors / nothing at all, depending on configuration.

Use the "Recent log messages" report or a syslog/Monolog backend to inspect
these entries during testing and in production.

The module bundles the standard Pesapal OAuth PHP helper in includes/OAuth.php
and uses Drupal's Guzzle HTTP client for status queries.

You should still run deprecation checks (drupal-check / phpstan-drupal) in your
own Drupal 10/11 + PHP 8.3 environment.
