<?php

namespace Drupal\commerce_pesapal\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Drupal\commerce_payment\Entity\PaymentGatewayInterface;

/**
 * Handles Pesapal IPN callbacks.
 *
 * This controller simply proxies the Request object to the payment gateway
 * plugin's onNotify() method, which contains the actual verification logic.
 */
class PesapalIpnController extends ControllerBase {

  /**
   * Notifies the Pesapal gateway.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The incoming request.
   *
   * @return \Symfony\Component\HttpFoundation\Response
   *   The HTTP response.
   */
  public function notify(Request $request) {
    // Load all enabled Pesapal gateways and pass the request to each of them.
    // Typically you will only have one Pesapal gateway configured.
    $storage = $this->entityTypeManager()->getStorage('commerce_payment_gateway');
    $gateways = $storage->loadMultiple();

    foreach ($gateways as $gateway) {
      if ($gateway instanceof PaymentGatewayInterface) {
        $plugin = $gateway->getPlugin();
        if ($plugin instanceof \Drupal\commerce_pesapal\Plugin\Commerce\PaymentGateway\PesapalRedirect) {
          // Delegate to the plugin's onNotify() implementation.
          return $plugin->onNotify($request);
        }
      }
    }

    // If we reached this point no matching gateway was found.
    return new Response('No Pesapal gateway configured', 404);
  }

}
