<?php

namespace Drupal\commerce_pesapal\Tests\Unit;

use Drupal\commerce_pesapal\Plugin\Commerce\PaymentGateway\PesapalRedirect;
use Drupal\Tests\UnitTestCase;
use Drupal\Core\DependencyInjection\ContainerBuilder;

/**
 * Basic unit tests for the PesapalRedirect plugin.
 *
 * This doesn't require a full Drupal bootstrap and is safe for PHP 8.3+.
 *
 * @group commerce_pesapal
 */
class PesapalRedirectTest extends UnitTestCase {

  /**
   * Tests the default configuration.
   */
  public function testDefaultConfiguration() {
    $container = new ContainerBuilder();
    \Drupal::setContainer($container);

    $plugin = new PesapalRedirect([], 'pesapal_redirect', []);
    $config = $plugin->getConfiguration();

    $this->assertArrayHasKey('consumer_key', $config);
    $this->assertArrayHasKey('consumer_secret', $config);
    $this->assertArrayHasKey('base_url', $config);
    $this->assertArrayHasKey('ipn_url', $config);
  }

}
