<?php

namespace Drupal\commerce_pricelist_schedule\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityChangedTrait;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the Commerce Pricelist Scheduled Import entity.
 *
 * @ContentEntityType(
 *   id = "pricelist_scheduled_import",
 *   label = @Translation("Commerce Pricelist Scheduled Import"),
 *   base_table = "pricelist_scheduled_import",
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid",
 *     "label" = "id"
 *   },
 *   handlers = {
 *     "list_builder" =
 *   "Drupal\commerce_pricelist_schedule\Entity\PricelistScheduledImportListBuilder",
 *     "form" = {
 *       "default" =
 *   "Drupal\commerce_pricelist_schedule\Form\ScheduleImportForm"
 *     }
 *   },
 *   links = {
 *     "canonical" =
 *   "/commerce-pricelist-scheduled-import/{pricelist_scheduled_import}",
 *     "edit-form" =
 *   "/commerce-pricelist-scheduled-import/{pricelist_scheduled_import}/edit",
 *     "delete-form" =
 *   "/commerce-pricelist-scheduled-import/{pricelist_scheduled_import}/delete"
 *   }
 * )
 */
class PricelistScheduledImport extends ContentEntityBase {

  use EntityChangedTrait;

  const STATUS_PENDING = 'pending';

  const STATUS_IN_PROGRESS = 'in_progress';

  const STATUS_COMPLETED = 'completed';

  const STATUS_FAILED = 'failed';

  const STATUS_CANCELLED = 'cancelled';

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = parent::baseFieldDefinitions($entity_type);

    // Primary ID.
    $fields['id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('ID'))
      ->setReadOnly(TRUE);

    // UUID.
    $fields['uuid'] = BaseFieldDefinition::create('uuid')
      ->setLabel(t('UUID'))
      ->setReadOnly(TRUE);

    // Reference to the Price List.
    $fields['commerce_pricelist'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Price List'))
      ->setSetting('target_type', 'commerce_pricelist')
      ->setRequired(TRUE);

    // Scheduled start time.
    $fields['scheduled_time'] = BaseFieldDefinition::create('datetime')
      ->setLabel(t('Scheduled Time'))
      ->setSettings([
        'datetime_type' => 'datetime',
      ])
      ->setRequired(TRUE);

    // Import status.
    $fields['status'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Status'))
      ->setDefaultValue(self::STATUS_PENDING)
      ->setRequired(TRUE);

    // Uploaded import file.
    $fields['import_file'] = BaseFieldDefinition::create('file')
      ->setLabel(t('Import File'))
      ->setSetting('file_extensions', 'csv txt')
      ->setSetting('uri_scheme', 'public')
      ->setRequired(TRUE);

    // Import settings (stored as long text).
    $fields['import_settings'] = BaseFieldDefinition::create('string_long')
      ->setLabel(t('Import Settings'))
      ->setRequired(FALSE);

    // Created timestamp.
    $fields['created'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Created'));

    // Changed timestamp.
    $fields['changed'] = BaseFieldDefinition::create('changed')
      ->setLabel(t('Changed'));

    return $fields;
  }

}
