<?php

/**
 * @file
 * Post-update hooks for the Commerce Product Review module.
 */

use Drupal\Core\Cache\Cache;

/**
 * Migrate show_overview_link to link_display = 'overview'.
 */
function commerce_product_review_post_update_migrate_link_display() {
  $config_factory = \Drupal::configFactory();
  $config_storage = \Drupal::service('config.storage');

  $configs = $config_storage->listAll('core.entity_view_display.commerce_product.');
  foreach ($configs as $config_name) {
    $config = $config_factory->getEditable($config_name);
    $content = $config->get('content');

    // Check if the overall_rating field exists and uses stars formatter.
    if (!empty($content['overall_rating']) && $content['overall_rating']['type'] === 'commerce_product_review_overall_rating_stars') {
      $settings = $content['overall_rating']['settings'];

      // Migrate the old setting to the new format.
      $settings['link_display'] = $settings['show_overview_link'] ? 'overview' : 'none';
      unset($settings['show_overview_link']);

      // Update the config.
      $content['overall_rating']['settings'] = $settings;
      $config->set('content', $content);
      $config->save();
    }
  }
}

/**
 * Add display_link setting to overall rating default formatter.
 */
function commerce_product_review_post_update_add_display_link() {
  $config_factory = \Drupal::configFactory();
  $config_storage = \Drupal::service('config.storage');

  $configs = $config_storage->listAll('core.entity_view_display.commerce_product.');
  foreach ($configs as $config_name) {
    $config = $config_factory->getEditable($config_name);
    $content = $config->get('content');

    // Check if the overall_rating field exists and uses default formatter.
    if (!empty($content['overall_rating']) && $content['overall_rating']['type'] === 'commerce_product_review_overall_rating_default') {
      $settings = $content['overall_rating']['settings'];

      // Set to FALSE to preserve existing appearance.
      $settings['display_link'] = FALSE;

      // Update the config.
      $content['overall_rating']['settings'] = $settings;
      $config->set('content', $content);
      $config->save();
    }
  }
}

/**
 * Add require title and require display name config to product review types.
 */
function commerce_product_review_post_update_add_required_type_config(): void {
  $config_factory = \Drupal::configFactory();
  $configs = $config_factory->listAll('commerce_product_review.commerce_product_review_type.');

  foreach ($configs as $config_name) {
    $config = $config_factory->getEditable($config_name);

    // Add new fields with default values if they don't exist.
    if (!$config->get('requireTitle')) {
      $config->set('requireTitle', FALSE);
    }
    if (!$config->get('requirePublishedAs')) {
      $config->set('requirePublishedAs', FALSE);
    }

    $config->save(TRUE);
  }
}

/**
 * Add missing published filter to the product reviews page view.
 */
function commerce_product_review_post_update_add_missing_published_filter(): void {
  $config_factory = \Drupal::configFactory();
  $config = $config_factory->getEditable('views.view.product_review_page');

  if ($config) {
    $filters = $config->get('display.default.display_options.filters');

    // Add the published filter.
    $filters['status'] = [
      'id' => 'status',
      'table' => 'commerce_product_review',
      'field' => 'status',
      'relationship' => 'none',
      'group_type' => 'group',
      'admin_label' => '',
      'entity_type' => 'commerce_product_review',
      'entity_field' => 'status',
      'plugin_id' => 'boolean',
      'operator' => '=',
      'value' => '1',
      'group' => 1,
      'exposed' => FALSE,
      'expose' => [
        'operator_id' => '',
        'label' => '',
        'description' => '',
        'use_operator' => FALSE,
        'operator' => '',
        'operator_limit_selection' => FALSE,
        'operator_list' => [],
        'identifier' => '',
        'required' => FALSE,
        'remember' => FALSE,
        'multiple' => FALSE,
        'remember_roles' => [
          'authenticated' => 'authenticated',
        ],
      ],
      'is_grouped' => FALSE,
      'group_info' => [
        'label' => '',
        'description' => '',
        'identifier' => '',
        'optional' => TRUE,
        'widget' => 'select',
        'multiple' => FALSE,
        'remember' => FALSE,
        'default_group' => 'All',
        'default_group_multiple' => [],
        'group_items' => [],
      ],
    ];

    $config->set('display.default.display_options.filters', $filters);
    $config->save(TRUE);

    // Clear views cache.
    Cache::invalidateTags(['views']);
  }
}
