Commerce Product Review
=======================

This module provides a review feature for 
[Drupal Commerce](http://drupal.org/project/commerce) products.

[Issue Tracker](https://www.drupal.org/project/issues/commerce_product_review)

## Features

### Frontend
- Allows customers to write reviews for products on your site. Customers are 
limited to one review per product.
- Automatic calculation and display of average ratings on products.
- Review sorting and filtering options on a product's reviews page.
- Logged out customers see a link inviting them to leave a review after being 
asked to log in.
- Customers can view, edit, and delete their own reviews when granted related 
permissions.
- Customer's reviews are displayed in a list on their account page.

### Design
- Configurable review types allow limiting to specific product types.
- Additional fields can be added to review types enabling extras like customer 
pictures, videos, etc.
- Ratings can be displayed as numbers or stars. Multiple format options for 
display.
- Reviews are displayed in a view. Layout can be customized in the view and 
using twig templates.

### Administration
- Fully featured administrative view of all reviews with sorting, filtering, 
and bulk actions.
- Bulk review management for efficiently managing large numbers of reviews. 
Publish, unpublish, or delete multiple reviews at once.
- Reviews can be published automatically on submission or stay unpublished 
until a site administrator publishes them.
- Fine grained permissions to control what customers can do with their own 
reviews.
- Email alerts can be sent when new reviews are submitted.

## Installation

It is recommended to use [Composer](https://getcomposer.org/) to get this module
with all dependencies:

```
composer require "drupal/commerce_product_review"
```

See the [Drupal](https://www.drupal.org/docs/8/extending-drupal-8/installing-modules-composer-dependencies)
documentation for more details.

### rateit.js Javascript library

The [rateit.js](https://github.com/gjunge/rateit.js) Javascript library is
required for displaying both rating values and rating form as stars. There are
two ways to include the library:

#### Install with Composer

If you have already installed the module via Composer, we recommend to do the
same with the rateit.js library. Changes are required to your composer.json file
to allow installing javascript libraries via composer correctly (in the required
destination path).

We highly recommend to use [Asset Packagist](https://asset-packagist.org) in
order to load Javascript libraries via Composer.

Add the following snippets into your project's composer.json file. If there are
already 'repositories' and/or 'extra' entries in your project's composer.json, merge
these new entries with the already existing entries.

Add this into the repositories section:

```
    "repositories": [
        {
            "type": "composer",
            "url": "https://asset-packagist.org"
        }
    ],
```

Add this to the extras section:

```
"extra": {
    "installer-types": [
        "bower-asset",
        "npm-asset"
    ],
    "installer-paths": {
        "web/libraries/{$name}": [
            "type:drupal-library",
            "type:bower-asset",
            "type:npm-asset"
        ],
    }
}
```

This specifies where the javascript library is installed in your project.

After that, run:

```
composer require "npm-asset/jquery.rateit"
```

#### Install Manually
[Download the library](https://github.com/gjunge/rateit.js/releases) and extract
the file under the "libraries" directory. Ensure, that the library's js and css
files are found within the following path: `libraries/jquery.rateit/scripts`

## Configuration

1. Install the module.
2. Go to the product review types page at `/admin/commerce/config/product-review-types`
3. Configure the "default" review type or create your own.  
    - On the edit page select which product types should be enabled for the given 
    product review type. You must select product types for the widget to appear.  
    - If you want to be notified of new product reviews enter an email address.  
    - You can optionally add your own fields to product review types, as well as 
    change the form and view display.
4. On the product type display configuration page 
(eg `/admin/commerce/config/product-types/default/edit/display`) ensure that 
"Overall rating" is enabled and placed in your desired location.
5. Adjust the permissions to your needs. By default, any user may view the
   published product reviews.  
   - Writing reviews is only allowed for authenticated users by default.  
   - Giving create access to guest users will not work as the module relies upon
   user accounts to enforce one review per person per product.  
   - New product reviews won't get published automatically without admin approval,
   unless you assign the "**Publish product review**" permission to the
   reviewing user's role.  

## Known Issues
The "Write the first review" link does not show up on products with no reviews
if layout builder is used on the product. There is a Drupal Core issue to
address this:  
[#3067982 Formatters for empty fields do not render with layout builder enabled](https://www.drupal.org/project/drupal/issues/3067982)

Core can be patched using the merge request [#12052](https://git.drupalcode.org/project/drupal/-/merge_requests/12052)  
Once patched there will be an option in the configuration for overall rating
"Show block when field is empty" that needs to be checked.

## Credits

<!--- cspell:disable -->
Commerce Product Review module was originally developed by [Mag. Andreas Mayr](https://www.drupal.org/u/agoradesign).

All initial development was sponsored by [agoraDesign KG](https://www.agoradesign.at).

Development of the 2.x version was sponsored by [New ProCycle LLC](https://procycle.us).

Currently maintained by [Mag. Andreas Mayr](https://www.drupal.org/u/agoradesign) 
and [Ryan Hovland](https://www.drupal.org/u/rhovland).
<!--- cspell:enable -->
