<?php

namespace Drupal\commerce_product_review\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Session\AccountInterface;

/**
 * Publishes a product review.
 *
 * @Action(
 *   id = "commerce_product_review_publish",
 *   label = @Translation("Publish selected product review"),
 *   type = "commerce_product_review"
 * )
 */
class PublishProductReview extends ActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    /** @var \Drupal\commerce_product_review\Entity\ProductReviewInterface $entity */
    $entity->setPublished(TRUE);
    $entity->save();
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, ?AccountInterface $account = NULL, $return_as_object = FALSE) {
    /** @var \Drupal\commerce_product_review\Entity\ProductReviewInterface $object */
    $result = $object
      ->access('update', $account, TRUE)
      ->andIf($object->status->access('edit', $account, TRUE));

    return $return_as_object ? $result : $result->isAllowed();
  }

}
