<?php

namespace Drupal\commerce_product_review\Form;

use Drupal\Core\Entity\ContentEntityDeleteForm;
use Drupal\Core\Url;

/**
 * Provides a form for deleting a product review.
 */
class ProductReviewDeleteForm extends ContentEntityDeleteForm {

  /**
   * {@inheritdoc}
   */
  protected function getDeletionMessage(): string {
    return $this->t('Your product review has been deleted.');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    /** @var \Drupal\commerce_product_review\Entity\ProductReviewInterface $review */
    $review = $this->getEntity();
    return new Url('entity.commerce_product.canonical', [
      'commerce_product' => $review->getProductId(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  protected function getRedirectUrl() {
    return $this->getCancelUrl();
  }

}
