<?php

namespace Drupal\commerce_product_review\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Session\AccountInterface;

/**
 * Unpublishes a product review.
 *
 * @Action(
 *   id = "commerce_product_review_unpublish",
 *   label = @Translation("Unpublish selected product review"),
 *   type = "commerce_product_review"
 * )
 */
class UnpublishProductReview extends ActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    /** @var \Drupal\commerce_product_review\Entity\ProductReviewInterface $entity */
    $entity->setUnpublished();
    $entity->save();
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, ?AccountInterface $account = NULL, $return_as_object = FALSE) {
    /** @var \Drupal\commerce_product_review\Entity\ProductReviewInterface $object */
    $access = $object
      ->access('update', $account, TRUE)
      ->andIf($object->status->access('edit', $account, TRUE));

    return $return_as_object ? $access : $access->isAllowed();
  }

}
