<?php

namespace Drupal\commerce_product_taxonomy_filter\Plugin\views\argument_validator;

use Drupal\views\Plugin\views\argument_validator\Entity;
use Drupal\views\Plugin\views\display\DisplayPluginBase;
use Drupal\views\ViewExecutable;

/**
 * Provides backward‑compatible vocabulary validation for Views term arguments.
 */
class Term extends Entity {

  /**
   * {@inheritdoc}
   */
  public function init(ViewExecutable $view, DisplayPluginBase $display, ?array &$options = NULL) {
    parent::init($view, $display, $options);

    // @todo Remove the legacy code.
    // Convert legacy vids option to machine name vocabularies.
    if (!empty($this->options['vids'])) {
      // Load all vocabularies using injected storage.
      $vocabularies = $this->entityTypeManager
        ->getStorage('taxonomy_vocabulary')
        ->loadMultiple();

      foreach ($this->options['vids'] as $vid) {
        // Only map if the vocabulary actually exists.
        if (isset($vocabularies[$vid])) {
          $machine_name = $vocabularies[$vid]->id();
          $this->options['vocabularies'][$machine_name] = $machine_name;
        }
      }
    }
  }

}
