# Commerce Profile Checkout Pane

This module provides a Drupal Commerce checkout pane for each Profile type
defined by the Profile module. The checkout pane renders a form, allowing
users to create a new profile entity or edit the existing one.

### Limitations

A checkout pane for the 'customer' profile type is provided by Commerce Core,
and is not also available from this module.

For profile types which allow multiple profile entities per user, this loads
the first such profile found.

A profile pane can not be put in the 'login' step, as that does not provide a
submit button for the whole form.

## Requirements

This module requires the following modules:

- Commerce 2.x or 3.x
- Profile 1.x (also required by Commerce)
- Inline Entity Form 1.x or 3.x

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

- If required, add a new Profile type in Config -> People -> Profile types.
- Navigate to Commerce -> Configuration -> Orders -> Checkout flows and edit
  the desired checkout flow.
- Move the "Profile type" profile form into an appropriate checkout step.
  Note that the 'login' step is not a workable option.
- Configure the settings for the profile form.

## Other modules

The following modules do similar things, but at present only have releases for
Drupal 7.

[Commerce User Profile Pane](https://www.drupal.org/project/commerce_user_profile_pane)
provides a pane to edit the user entity, rather than profiles.

[Commerce Profile2 Checkout Pane](https://www.drupal.org/project/commerce_p2cp)
provides a pane to edit Profile 2 profile entities, on Drupal 7.
