<?php

declare(strict_types=1);

namespace Drupal\Tests\commerce_recruiting\Kernel\Controller;

use Drupal\commerce_recruiting\Controller\RecruitmentCodeController;
use Drupal\commerce_recruiting\RecruitmentSessionInterface;
use Drupal\Tests\commerce_recruiting\Kernel\CommerceRecruitingKernelTestBase;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Tests the recruitment code controller redirect flow.
 *
 * @group commerce_recruiting
 */
class RecruitmentCodeControllerTest extends CommerceRecruitingKernelTestBase {

  /**
   * The controller under test.
   *
   * @var \Drupal\commerce_recruiting\Controller\RecruitmentCodeController
   */
  protected $controller;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->controller = RecruitmentCodeController::create($this->container);
  }

  /**
   * Ensures a valid code stores session and redirects to product.
   */
  public function testValidCodeRedirectsAndStoresSession(): void {
    $recruiter = $this->createUser();
    $campaign = $this->createCampaign($recruiter);
    $option = $campaign->getFirstOption();

    // Act as another user to avoid self-recruit restriction.
    $visitor = $this->createUser();
    $this->container->get('current_user')->setAccount($visitor);

    $code = $option->getCode() . '--' . $recruiter->id();
    $response = $this->controller->code($code);

    $this->assertInstanceOf(RedirectResponse::class, $response, 'Controller returns redirect response.');
    $this->assertStringContainsString((string) $option->getProduct()->id(), $response->getTargetUrl(), 'Redirect targets product.');

    /** @var \Drupal\commerce_recruiting\RecruitmentSessionInterface $session */
    $session = $this->container->get('commerce_recruiting.recruitment_session');
    $this->assertInstanceOf(RecruitmentSessionInterface::class, $session, 'Recruitment session service available.');
    $this->assertEquals($recruiter->id(), $session->getRecruiter()->id(), 'Recruiter stored in session.');
    $this->assertEquals($option->id(), $session->getCampaignOption()->id(), 'Campaign option stored in session.');
  }

}
