<?php

namespace Drupal\Tests\commerce_recruiting\Kernel;

/**
 * Kernel tests for recruitment session storage.
 *
 * @group commerce_recruiting
 */
class RecruitmentSessionTest extends CommerceRecruitingKernelTestBase {

  /**
   * The recruitment session.
   *
   * @var \Drupal\commerce_recruiting\RecruitmentSessionInterface
   */
  private $recruitmentSession;

  /**
   * Test getRecruiter.
   */
  public function testGetRecruiter() {
    $expected_recruiter = $this->createUser();
    $this->recruitmentSession->setRecruiter($expected_recruiter);
    $loaded_recruiter = $this->recruitmentSession->getRecruiter();
    $this->assertEquals($expected_recruiter->id(), $loaded_recruiter->id(), 'Recruitment session returns assigned recruiter.');
  }

  /**
   * Test getRecruitmentConfig.
   */
  public function testGetRecruitmentConfig() {
    $expected_campaign = $this->createCampaign();
    $options = $expected_campaign->getOptions();
    $this->assertEquals(count($options), 1, 'Campaign has a single option.');
    $expected_option = current($options);
    $this->recruitmentSession->setCampaignOption($expected_option);
    $loaded_config = $this->recruitmentSession->getCampaignOption();
    $this->assertEquals($expected_option->id(), $loaded_config->id(), 'Recruitment session returns assigned option.');
  }

  /**
   * Test setUp.
   */
  protected function setUp(): void {
    parent::setUp();
    /** @var \Drupal\commerce_recruiting\RecruitmentSessionInterface recruitingSession */
    $this->recruitmentSession = \Drupal::service('commerce_recruiting.recruitment_session');
  }

}
