<?php

namespace Drupal\Tests\commerce_recruiting\Kernel;

use Drupal\Tests\commerce_recruiting\Traits\RecruitmentEntityCreationTrait;

/**
 * Kernel tests for reward creation workflows.
 *
 * @group commerce_recruiting
 */
class RewardManagerTest extends CommerceRecruitingKernelTestBase {

  use RecruitmentEntityCreationTrait;

  /**
   * Test createReward.
   */
  public function testCreateReward() {
    $recruiter = $this->createUser();
    $campaign = $this->createCampaign($recruiter);
    $recruited = $this->createUser();
    $products = [];
    $products[] = $this->createProduct();
    $products[] = $this->createProduct();
    $recruitments = $this->createRecruitings($campaign, $recruiter, $recruited, $this->createOrder($products));
    $this->assertEquals(count($recruitments), 2, 'Two recruitments created for two products.');
    $this->recruitmentManager->applyTransitions('accept');
    $reward = $this->rewardManager->createReward($campaign, $recruiter);
    $this->assertEquals(count($reward->getRecruitments()), 2, 'Reward aggregates two recruitments.');
    /** @var \Drupal\commerce_recruiting\Entity\RecruitmentInterface $recruitment */
    foreach ($reward->getRecruitments() as $recruitment) {
      $this->assertEquals($recruitment->getState()->getId(), 'paid_pending', 'Recruitment transitions to paid_pending.');
    }
    $reward->setState('paid');
    $reward->save();
    foreach ($reward->getRecruitments() as $recruitment) {
      $this->assertEquals($recruitment->getState()->getId(), 'paid', 'Recruitment transitions to paid after reward set.');
    }
    $this->assertEquals(20.000000, $reward->getPrice()->getNumber(), 'Reward price sums accepted recruitments.');

  }

}
