<?php

namespace Drupal\commerce_reengage\EventSubscriber;

use Drupal\commerce_order\Event\OrderEvent;
use Drupal\commerce_order\Event\OrderEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * 
 * Updates the reengage_tracker status when an order is completed.
 */
class CommerceReengageOrderSubscriber implements EventSubscriberInterface {

  public static function getSubscribedEvents() {
    return [
      OrderEvents::ORDER_UPDATE => 'onOrderPlace',
    ];
  }

  /**
   **
   * @param \Drupal\commerce_order\Event\OrderEvent $event
   *   The order event.
   */

  public function onOrderPlace(OrderEvent $event) {
    $order = $event->getOrder();
    if ($order->getState()->value === 'completed') {
      $tracker_id = $order->getData('reengage_tracker_id');
      
      if ($tracker_id) {
        $tracker = \Drupal::entityTypeManager()
          ->getStorage('reengage_tracker')
          ->load($tracker_id);

        if ($tracker) {
          $tracker->set('status', 'success')->save();
        }
      }
    }
  }

}
