<?php

namespace Drupal\Commerce_reengage\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;
use Drupal\user\Entity\User;

class CommerceReengageRulesForm extends ContentEntityForm{
	public function buildForm(array $form, FormStateInterface $form_state){
		$form = parent::buildForm($form, $form_state);

		$entity = $this->entity;

		$form['delivery_time'] = [
			'#type' => 'number',
			'#title' => $this->t('Delivery Time (sec) '),
			'#required' => TRUE,
			'#min' => 60,
			'#default_value' => $this->entity->get('delivery_time')->value ?? 300,
			'#description' => $this->t('Specify how long to wait before sending the abandoned cart message, in seconds. <br><b><em> Note: 1 minute = 60 seconds.</em></b>'),
			'#weight' => 2,
		];

		$form['batch'] = [
			'#type' => 'number',
			'#title' => $this->t("Mail Count (Batch)"),
			'#required' => TRUE,
			'#min' => 0,
			'#default_value' => $this->entity->get('batch')->value ?? 0,
			'#description' => $this->t('Specify the maximum number of emails that will be processed during each scheduled run. <br> <b><em> Use a value of 0 to send all queued emails immediately (unlimited batch size).</em> </b>'),
			'#weight' => 5,
		];

		$form['priority'] = [
			'#type' => 'number',
			'#title' => $this->t('Priority'),
			'#default_value' => $this->entity->get('priority')->value ?? 10,
			'#required' => TRUE,
			'#min' => 1,
			'#description' => $this->t('Enter a priority for sending the mail. <b>NOTE:</b> Lower value = higher priority. <br><em>Example: 1 is the highest priority.</em>'),
			'#weight' => 6,
		];

		$form['mail_subject'] = [
			'#type' => 'textfield',
			'#title' => $this->t("Mail Subject"),
			'#required' => TRUE,
			'#default_value' => $this->entity->get('mail_subject')->value ?? t("Your cart is waiting!"),
			'#description' => $this->t('Enter a subject line using your creativity. You can also use the available tokens below, such as <br><b>[user:name]</b>.'),
			'#weight' => 8,
		];


		$form['mail_content'] = [
			'#type' => 'text_format',
			'#title' => $this->t('Email Body Content'),
			'#format' => $this->entity->get('mail_content')->format ?? 'basic_html',
			'#default_value' => $this->entity->get('mail_content')->value ?? "<h2>Dear [user:name],</h2>
				<p>You visited [commerce_reengage:visited_time] our site [site:name] and... oops... you left us checking out.</p>
				<p>Look at the items we're holding for you. This reminder encourages you to complete your purchase and enjoy a special offer.</p>
				<div style='text-align:center;'>
				<p style='font-weight: bold; font-size:20px;'>Your coupon code:</p>
				<p style='color:blue; font-size:24px; border:2px solid black; width: fit-content; margin:0 auto; padding: 10px;'>[commerce_reengage:promotion_code]</p>
				</div>",
			'#description' => $this->t('You can use tokens like <br> <b><code> [user:name], [commerce_reengage:visited_time], [site:name], [commerce_reengage:promotion_code].</code> </b>'),
			'#required' => TRUE,
			'#weight' => 10,
			'#max' => 2000,
		];

		if (\Drupal::moduleHandler()->moduleExists('token')) {
		$form['mail_content']['token_help'] = [
			'#theme' => 'token_tree_link',
			'#token_types' => ['commerce_order', 'commerce_cart', 'user', 'site', 'commerce_reengage', 'current-date', 'random'],
			'#global_types' => FALSE,
			'#dialog' => TRUE,
			'#weight' => 11,
		];
		}

		return $form;
	}

	public function save(array $form, FormStateInterface $form_state ){
		$entity = $this->getEntity();
		$status = parent::save($form, $form_state);

		if ($status == SAVED_NEW) {
		$this->messenger()->addMessage(
				$this->t('Created %label rules', ['%label' => $entity->label()])
		);
		}
		else {
		$this->messenger()->addMessage(
				$this->t('Updated %label rules', ['%label' => $entity->label()])
		);
		}

		$account = \Drupal::currentUser();

		if ($account->hasRole('administrator')) {
				$form_state->setRedirect('entity.commerce_reengage_rules.collection');
		} else {
				$form_state->setRedirect('<front>');
		}
	}
}