<?php

namespace Drupal\commerce_reengage\Plugin\Commerce\InlineForm;

use Drupal\commerce_promotion\Plugin\Commerce\InlineForm\CouponRedemption;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Component\Utility\NestedArray;
use Drupal\commerce\Attribute\CommerceInlineForm;

/**
 * Extends coupon redemption to update reengage_tracker status.
 */
#[CommerceInlineForm(
  id: "coupon_redemption",
  label: new TranslatableMarkup("Coupon redemption (Reengage extended)"),
)]
class CommerceReengageCouponRedemption extends CouponRedemption {

  /**
   * {@inheritdoc}
   */
  public static function applyCoupon(array $form, FormStateInterface $form_state) {
    parent::applyCoupon($form, $form_state);

    $triggering_element = $form_state->getTriggeringElement();
    $parents = array_slice($triggering_element['#parents'], 0, -1);
    $inline_form = NestedArray::getValue($form, $parents);
    $order_storage = \Drupal::entityTypeManager()->getStorage('commerce_order');
    $order = $order_storage->load($inline_form['#configuration']['order_id']);

    if (!$order) {
      \Drupal::logger('commerce_reengage')->error('Order not found while updating reengage_tracker.');
      return;
    }

    $trackerEntities = \Drupal::entityTypeManager()
      ->getStorage('reengage_tracker')
      ->loadByProperties(['order_id' => $order->id()]);

    $trackerEntity = $trackerEntities ? reset($trackerEntities) : NULL;

    if (!$trackerEntity) {
      $this->messenger()->addError($this->t('Invalid coupon link.'));
      return new RedirectResponse('/cart');
    }

    $coupon_id = $trackerEntity->get('promotion_code')->target_id ?? NULL;

    $coupon = $coupon_id ? \Drupal::entityTypeManager()
      ->getStorage('commerce_promotion_coupon')
      ->load($coupon_id) : NULL;

    if (!$coupon || !$coupon->isEnabled()) {
      $this->messenger()->addError($this->t('This coupon has expired or is no longer valid.'));
      return new RedirectResponse('/cart');
    }

    $trackerEntity->set('status', 'partial_success')->save(); 

  }
}
