<?php

namespace Drupal\commerce_reengage;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;
use Drupal\Core\Url;

/**
 * 
 * Defines a list builder for Reengage Log entities.
 */
class ReengageTrackerListBuilder extends EntityListBuilder {

  /**
   * 
   * {@inheritdoc}
   */
  
  public function buildHeader() {
    $header['id'] = $this->t('ID');
    $header['promotion_code'] = $this->t('Promotion code');
    $header['order'] = $this->t('Order');
    $header['rule'] = $this->t('Rule');
    $header['mail_sent_time'] = $this->t('Mail sent time');
    $header['status'] = $this->t('Status');
    $header['changed'] = $this->t('Changed');

    return $header + parent::buildHeader();
  }

  /**
   * 
   * {@inheritdoc}
   */
  
  public function buildRow(EntityInterface $entity) {
    /* @var \Drupal\commerce_reengage\Entity\ReengageLog $entity */
    $row['id'] = $entity->id();

    $coupon_id = $entity->get('promotion_code')->target_id;
    if ($coupon_id) {
      $coupon = \Drupal::entityTypeManager()
        ->getStorage('commerce_promotion_coupon')
        ->load($coupon_id);
      $row['promotion_code'] = $coupon ? $coupon->getCode() : '-';
    }
    else {
      $row['promotion_code'] = '-';
    }

    $order = $entity->get('order_id')->entity;
    $row['order'] = $order ? Link::fromTextAndUrl($order->id(), Url::fromRoute('entity.commerce_order.canonical', ['commerce_order' => $order->id()]))->toString() : $this->t('—');
    $rule = $entity->get('rule')->entity;
    $row['rule'] = $rule ? $rule->label() : $this->t('—');

    $mailSendTime = $entity->get('mail_sent_time')->value;
    $row['mail_sent_time'] = date("M j, Y g:i A", $mailSendTime);

    $row['status'] = $entity->get('status')->value ?: $this->t('pending');

    $modifiedAt = $entity->get('changed')->value;
    $row['changed'] = date("M j, Y g:i A",$modifiedAt);

    return $row + parent::buildRow($entity);
  }
}
