<?php

namespace Drupal\commerce_reengage\Service;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Database\Connection;
use Psr\Log\LoggerInterface;
use Drupal\commerce_order\Entity\Order;
use Drupal\commerce_reengage\Entity\CommerceReengageRulesEntity;

class AbandonedCartManager {

  protected $entityTypeManager;
  protected $database;
  protected $logger;

  public function __construct(EntityTypeManagerInterface $entityTypeManager, Connection $database, LoggerInterface $logger) {
    $this->entityTypeManager = $entityTypeManager;
    $this->database = $database;
    $this->logger = $logger;
  }

  public function abandonedCartsByRules() {
    $storage = $this->entityTypeManager->getStorage('commerce_reengage_rules');
    $rules = $storage->loadMultiple();

    $eligible = [];

    foreach ($rules as $rule) {
      $delay = (int) $rule->get('delivery_time')->value;

      $carts = $this->getAbandonedCarts($delay);

      foreach ($carts as $cart) {
        $eligible[] = [
          'rule' => $rule,
          'cart' => $cart,
        ];
      }
    }

    return $eligible;
  }

  /**
   * Get carts that are abandoned based on delivery time.
   *
   * @param int $seconds
   *   Delay in minutes (from abandoned_cart_rule.delivery_time).
   *
   * @return \Drupal\commerce_order\Entity\Order[]
   *   List of abandoned orders.
   */
  public function getAbandonedCarts($seconds) {
    $storage = $this->entityTypeManager->getStorage('commerce_order');

    $timestamp = \Drupal::time()->getRequestTime() - ($seconds);

    $query = $storage->getQuery()
      ->condition('cart', TRUE) 
      ->condition('state', 'draft')
      ->condition('total_price__number', 0, '>')
      ->condition('changed', $timestamp, '<')
      ->exists('mail')
      ->accessCheck(FALSE);

    $order_ids = $query->execute();

    if (empty($order_ids)) {
      return [];
    }

    return $storage->loadMultiple($order_ids);
  }

}
