<?php

namespace Drupal\commerce_reengage;

use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

class CommerceReengageRulesListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */

  public function buildHeader() {
    $header['id'] = $this->t('ID');
    $header['rule_name'] = $this->t('Name');
    $header['status'] = $this->t('Status');
    $header['delivery_time'] = $this->t('Delivery Time');
    $header['discount_rule'] = $this->t('Discount Rule');
    $header['created'] = $this->t('Created At');
    $header['changed'] = $this->t('Modified At');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  
  public function buildRow(EntityInterface $entity) {
    $row['id'] = $entity->id();
    $row['rule_name'] = $entity->get('rule_name')->value;
    $row['status'] = $entity->get('status')->value ? "Enabled" : "Disabled";

    $min = $entity->get("delivery_time")->value;

    if($min >= 31536000){
      $years = floor($min/31536000);
      $row['delivery_time'] = $years . 'year' . ($years > 1 ? 's' : '');
    }
    elseif($min >= 2592000){
      $months = floor($min/2592000);
      $row['delivery_time'] = $months . " month" . ($months > 1 ? 's' : '');
    }
    elseif($min >= 604800){
        $weeks = floor($min/604800);
        $row['delivery_time'] =  $weeks . " week" . ($weeks > 1 ? 's' : '');
    }
    elseif($min >= 86400){
        $days = floor($min/86400);
        $row["delivery_time"] = $days . " day" . ($days > 1 ? 's' : '');
    }
    elseif($min >= 3600){
        $hrs = floor($min/3600);
        $row['delivery_time'] = $hrs . " hour" . ($hrs > 1 ? 's' : '');
    }
    elseif($min >= 60){
        $mints = floor($min/60);
        $row["delivery_time"] = $mints . " minute" . ($mints > 1 ? 's' : '');
    }
    else{
        $row['delivery_time'] = $min . " second" . ($min > 1 ? 's' : ''); 
    }

   $row['discount_rule'] = $entity->get("discount_rule")->entity?->label() ?? '';

    $created_timestrap = $entity->get("created") -> value;
    $changed_timestrap = $entity->get("changed") -> value;
    $row['created'] = date("M j, Y g:i A", $created_timestrap);
    $row['changed'] = date("M j, Y g:i A", $changed_timestrap);
    $row['operations']['data'] = [
      '#type' => 'operations',
      '#links' => [
        'edit' => [
          'title' => $this->t('Edit'),
          'url' => Url::fromRoute('entity.commerce_reengage_rules.edit-form', ['commerce_reengage_rules' => $entity->id()]),
        ],
        'delete' => [
          'title' => $this->t('Delete'),
          'url' => Url::fromRoute('entity.commerce_reengage_rules.delete-form', ['commerce_reengage_rules' => $entity->id()]),
        ],
      ],
    ];

    return $row + parent::buildRow($entity);
  }
}
