<?php

namespace Drupal\commerce_reengage\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\commerce_order\Entity\Order;
use Drupal\commerce_promotion\Entity\Coupon;

class ReengageController extends ControllerBase {

  public function applyCoupon($uuid, Request $request) {
    $trackerEntities = \Drupal::entityTypeManager()
      ->getStorage('reengage_tracker')
      ->loadByProperties(['uuid' => $uuid]);

    /** @var \Drupal\commerce_reengage\Entity\ReengageTrackerEntity $trackerEntity */

    $trackerEntity = $trackerEntities ? reset($trackerEntities) : NULL;

    if (!$trackerEntity) {
      $this->messenger()->addError($this->t('Invalid coupon link.'));
      return new RedirectResponse('/cart');
    }

    $coupon_id = $trackerEntity->get('promotion_code')->target_id ?? NULL;

    /** @var \Drupal\commerce_promotion\Entity\Coupon $coupon */

    $coupon = $coupon_id ? \Drupal::entityTypeManager()
      ->getStorage('commerce_promotion_coupon')
      ->load($coupon_id) : NULL;

    if (!$coupon || !$coupon->isEnabled()) {
      $this->messenger()->addError($this->t('This coupon has expired or is no longer valid.'));
      return new RedirectResponse('/cart');
    }

    $order_id = $trackerEntity->get('order_id')->target_id ?? NULL;
    $order = $order_id ? Order::load($order_id) : NULL;

  if ($order) {
    $current_user = \Drupal::currentUser();

    if ($order->getCustomerId() == $current_user->id()) {
      
      $coupon_already_applied = FALSE;

      foreach($order->get('coupons')->referencedEntities() as $existCoupon){
        if($existCoupon->id() === $coupon->id()){
          $coupon_already_applied = TRUE;
          $this->messenger()->addWarning($this->t('This coupon is already applied to your order.'));
          return new RedirectResponse('/checkout/' . $order->id()); 
        }
      }

      if (!$coupon_already_applied) {
        $order->get('coupons')->appendItem($coupon);
        $order->setData('reengage_tracker_id', $trackerEntity->id());

        \Drupal::service('commerce_order.order_refresh')->refresh($order);
        $order->save();

        $trackerEntity->set('status', 'partial_success')->save(); 

        $this->messenger()->addStatus($this->t('Your coupon has been applied.'));

        return new RedirectResponse('/checkout/' . $order->id());
      }

    }
    else {
      $this->messenger()->addError($this->t('The order you are attempting to modify does not belong to your account.'));
      return new RedirectResponse('/cart');
    }
  }

  $this->messenger()->addError($this->t('Unable to apply coupon. The order could not be found or processed.'));
  return new RedirectResponse('/cart');
  }
}
