<?php

namespace Drupal\commerce_reengage\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the Commerce Reengage Rules entity.
 *
 * @ContentEntityType(
 *   id = "commerce_reengage_rules",
 *   label = @Translation("Commerce Reengage rules"),
 *   base_table = "rules",
 *   handlers = {
 *     "form" = {
 *       "default" = "Drupal\commerce_reengage\Form\CommerceReengageRulesForm",
 *       "add" = "Drupal\commerce_reengage\Form\CommerceReengageRulesForm",
 *       "edit" = "Drupal\commerce_reengage\Form\CommerceReengageRulesForm",
 *       "delete" = "Drupal\commerce_reengage\Form\CommerceReengageRulesDeleteForm"
 *     },
 *     "list_builder" = "Drupal\commerce_reengage\CommerceReengageRulesListBuilder",
 *     "views_data" = "Drupal\commerce_reengage\Entity\ReengageRulesEntityViewsData"
 *   },
 *   entity_keys = {
 *      "id" = "id",
 *      "label" = "rule_name"
 *   },
 *   links = {
 *     "add-form" = "/commerce_reengage_rules/add",
 *     "edit-form" = "/commerce_reengage_rules/{commerce_reengage_rules}/edit",
 *     "delete-form" = "/commerce_reengage_rules/{commerce_reengage_rules}/delete",
 *     "collection" = "/admin/content/commerce_reengage_rules"
 *   }
 * )
 */

class CommerceReengageRulesEntity extends ContentEntityBase {

  /**
   * {@inheritdoc}
   * 
   * Defines the fields are ID, Status, rule_name, delivery_time, discount_rule, priority, created , changed 
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t("ID"))
      ->setReadOnly(TRUE);

    $fields['status'] = BaseFieldDefinition::create('boolean')
      ->setLabel(t('Enabled'))
      ->setRequired(TRUE)
      ->setDefaultValue(TRUE)
      ->setDisplayOptions('form', [
        'type' => 'boolean_checkbox',
        'weight' => 1,
      ])
      ->setDisplayOptions('view', [
        'type' => 'boolean',
        'weight' => 1,
      ])
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayConfigurable('view', TRUE);

    $fields['rule_name'] = BaseFieldDefinition::create('string')
      ->setLabel(t("Name"))
      ->setRequired(TRUE)
      ->setSettings(['max_length' => 255])
      ->setDisplayOptions('form', [
        'type' => 'string_textfield',
        'description' => "Enter the Name of the rule eg:10% Offer",
        'weight' => 2,
        'settings' => [
          'placeholder' => t('Enter the Rule Name'),
        ],
      ])
      ->setDisplayOptions('view', [
        'type' => 'string',
        'label' => 'above',
        'weight' => 2,
      ])
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayConfigurable('view', TRUE); 

    $fields['delivery_time'] = BaseFieldDefinition::create('integer');

    $fields['discount_rule'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t("Discount Rule"))
      ->setSetting('target_type', 'commerce_promotion')
      ->setDisplayOptions('form', [
        'type' => 'options_select',
        'weight' => 4,
      ])
      ->setRequired(TRUE)
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayConfigurable('view', TRUE);

    $fields['batch'] = BaseFieldDefinition::create('integer');

    $fields['priority'] = BaseFieldDefinition::create('integer');

    $fields['mail_subject'] = BaseFieldDefinition::create('string');

    $fields['mail_content'] = BaseFieldDefinition::create('text_with_summary')
      ->setLabel(t('Email body'))
      ->setDescription(t('The email message content with summary and format.'))
      ->setRequired(TRUE);

    $fields['created'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Created'))
      ->setDescription(t('Created time'));

    $fields['changed'] = BaseFieldDefinition::create('changed')
      ->setLabel(t('Changed'));

    return $fields;
  }
}