<?php
namespace Drupal\commerce_reengage\Entity;

use Drupal\commerce_promotion\Entity\Coupon as BaseCoupon;
use Drupal\commerce_order\Entity\OrderInterface;

class Coupon extends BaseCoupon {

  /**
   * {@inheritdoc}
   */
  public function available(OrderInterface $order = NULL) {
    if (!$this->isEnabled()) {
      return FALSE;
    }

    $promotion = $this->getPromotion();
    if (!$promotion || !$promotion->available($order)) {
      return FALSE;
    }

    // If no order is given (like in admin listings), skip date checks.
    if ($order) {
      $date = $order->getCalculationDate();
      $store_timezone = $date->getTimezone()->getName();

      $start_date = $this->getStartDate($store_timezone);
      if ($start_date) {
        $start_date_midnight = clone $start_date;
        $start_date_midnight->setTime(0, 0, 0);
        if ($start_date_midnight->format('U') > $date->format('U')) {
          return FALSE;
        }
      }

      $end_date = $this->getEndDate($store_timezone);
      if ($end_date && $end_date->format('U') <= $date->format('U')) {
        return FALSE;
      }
    }

    // Coupon exclusivity: only one coupon from this promo unless allowed.
    if ($order) {
      $coupons = $order->get('coupons')->referencedEntities();
      foreach ($coupons as $coupon) {
        if (
          $this->id() !== $coupon->id() &&
          $promotion->id() === $coupon->getPromotionId() &&
          !$promotion->isMultipleCouponsAllowed()
        ) {
          return FALSE;
        }
      }
    }

    // Usage limits.
    $usage_limit = $this->getUsageLimit();
    $usage_limit_customer = $this->getCustomerUsageLimit();
    if (!$usage_limit && !$usage_limit_customer) {
      return TRUE;
    }

    /** @var \Drupal\commerce_promotion\PromotionUsageInterface $usage */
    $usage = \Drupal::service('commerce_promotion.usage');

    if ($usage_limit && $usage_limit <= $usage->loadByCoupon($this)) {
      return FALSE;
    }

    if ($usage_limit_customer && $order && $order->getEmail()) {
      $email = $order->getEmail();
      if ($usage_limit_customer <= $usage->loadByCoupon($this, $email)) {
        return FALSE;
      }
    }

    return TRUE;
  }

}
