<?php

namespace Drupal\commerce_reengage\Entity;

use Drupal\commerce_promotion\Entity\Promotion as BasePromotion;
use Drupal\commerce_order\Entity\OrderInterface;

class Promotion extends BasePromotion {

  /**
   * {@inheritdoc}
   */
  public function available(OrderInterface $order = NULL) {
    if (!$this->isEnabled()) {
      return FALSE;
    }

    if ($this->requiresCoupon() && !$this->hasCoupons()) {
      return FALSE;
    }

    // Skip order-specific checks if no order (admin listings, etc.).
    if ($order) {
      if (!in_array($order->bundle(), $this->getOrderTypeIds())) {
        return FALSE;
      }
      if (!empty($this->getStoreIds()) && !in_array($order->getStoreId(), $this->getStoreIds())) {
        return FALSE;
      }

      $date = $order->getCalculationDate();
      $store_timezone = $date->getTimezone()->getName();

      $start_date = $this->getStartDate($store_timezone);
      if ($start_date) {
        $start_date_midnight = clone $start_date;
        $start_date_midnight->setTime(0, 0, 0);
        if ($start_date_midnight->format('U') > $date->format('U')) {
          return FALSE;
        }
      }

      $end_date = $this->getEndDate($store_timezone);
      if ($end_date && $end_date->format('U') <= $date->format('U')) {
        return FALSE;
      }
    }

    // Usage limits.
    $usage_limit = $this->getUsageLimit();
    $usage_limit_customer = $this->getCustomerUsageLimit();
    if (!$usage_limit && !$usage_limit_customer) {
      return TRUE;
    }

    /** @var \Drupal\commerce_promotion\PromotionUsageInterface $usage */
    $usage = \Drupal::service('commerce_promotion.usage');

    if ($usage_limit && $usage_limit <= $usage->load($this)) {
      return FALSE;
    }

    if ($usage_limit_customer && $order && $order->getEmail()) {
      $email = $order->getEmail();
      if ($usage_limit_customer <= $usage->load($this, $email)) {
        return FALSE;
      }
    }

    return TRUE;
  }

}
