<?php

namespace Drupal\commerce_reengage\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\Core\Entity\EntityChangedTrait;
use Drupal\Core\Entity\EntityStorageInterface;

/**
 * Defines the Reengage Log entity.
 *
 * @ContentEntityType(
 *   id = "reengage_tracker",
 *   label = @Translation("Reengage Tracker"),
 *   handlers = {
 *     "views_data" = "Drupal\commerce_reengage\Entity\ReengageTrackerEntityViewsData"
 *   },
 *   base_table = "reengage_tracker",
 *   admin_permission = "administer reengage tracker",
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid",
 *     "label" = "promotion_code"
 *   },
 *   links = {
 *     "canonical" = "/reengage_tracker/{reengage_tracker}",
 *     "collection" = "/admin/content/reengage_tracker"
 *   }
 * )
 */
class ReengageTrackerEntity extends ContentEntityBase {
  use EntityChangedTrait;

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('ID'))
      ->setReadOnly(TRUE);

    $fields['uuid'] = BaseFieldDefinition::create('uuid')
      ->setLabel(t('UUID'))
      ->setReadOnly(TRUE);

    $fields['order_id'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Order'))
      ->setDescription(t('Reference to the Commerce Order.'))
      ->setSetting('target_type', 'commerce_order')
      ->setDisplayOptions('view', [
        'label' => 'hidden',
        'type' => 'entity_reference_label',
        'weight' => 0,
      ])
      ->setDisplayOptions('form', [
        'type' => 'entity_reference_autocomplete',
        'weight' => 0,
      ]);

    $fields['rule'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Rule'))
      ->setDescription(t('The rule that was applied.'))
      ->setSetting('target_type', 'commerce_reengage_rules')
      ->setDisplayOptions('view', [
        'label' => 'above',
        'type' => 'entity_reference_label',
      ])
      ->setDisplayOptions('form', [
        'type' => 'entity_reference_autocomplete',
      ]);

    $fields['promotion_code'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Promotion Coupon'))
      ->setDescription(t('The coupon generated and sent to the customer.'))
      ->setSetting('target_type', 'commerce_promotion_coupon')
      ->setRequired(TRUE);

    $fields['mail_sent_time'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Mail sent time'))
      ->setDescription(t('Unix timestamp when the reengagement email was sent. Initially null.'))
      ->setDisplayOptions('view', [
        'label' => 'above',
        'type' => 'timestamp',
      ])
      ->setDisplayOptions('form', [
        'type' => 'datetime_timestamp',
      ]);

    $fields['status'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Status'))
      ->setDescription(t('Status of the reengagement: sent | partial_success | success'))
      ->setSettings([
        'max_length' => 32,
      ])
      ->setDisplayOptions('view', [
        'label' => 'above',
        'type' => 'string',
      ])
      ->setDisplayOptions('form', [
        'type' => 'options_select',
      ]);

    $fields['created'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Created'))
      ->setDescription(t('Created time'));

    $fields['changed'] = BaseFieldDefinition::create('changed')
      ->setLabel(t('Changed'));

    return $fields;
  }
}
