<?php

namespace Drupal\commerce_satispay\Commands;


use Drush\Commands\DrushCommands;
use Drush\Exceptions\CommandFailedException;
use \SatispayGBusiness\Api;

/**
 * A Drush commandfile.
 *
 * In addition to this file, you need a drush.services.yml
 * in root of your module, and a composer.json file that provides the name
 * of the services file to use.
 *
 * See these files for an example of injecting Drupal services:
 *   - http://cgit.drupalcode.org/devel/tree/src/Commands/DevelCommands.php
 *   - http://cgit.drupalcode.org/devel/tree/drush.services.yml
 */
class SatispayDrushCommands extends DrushCommands
{

  /**
   * Drush command to generate the keys required for authentication with satispay
   *
   * @param string $activation_code
   *   Argument with message to be displayed.
   * @command commerce_satispay:generatekey
   * @aliases satispay-generatekey
   * @option sandbox
   *   User Sandbox enviroment.
   * @usage commerce_satispay:generatekey  ACTIVATION_CODE
   */
  public function generatekey($activation_code = '', $options = [
    'save' => FALSE,
    'sandbox' => FALSE,
  ]) {
    if ($activation_code == '') {
      $this->output()->writeln('ACTIVATION_TOKEN is required');
    }
    else {

      if ($options['sandbox']) {
        \SatispayGBusiness\Api::setSandbox(TRUE);
      }
      try {
        $authentication = \SatispayGBusiness\Api::authenticateWithToken($activation_code);
        $publicKey = $authentication->publicKey;
        $privateKey = $authentication->privateKey;
        $keyId = $authentication->keyId;
        $this->output()->writeln("Activation codes are disposable: Please SAVE this result on a safe place");
        $this->output()->writeln("SandBox: " . $options['sandbox']);
        $this->output()->writeln("Activation code:\n$activation_code");
        $this->output()->writeln("Pubblic Key:\n$publicKey");
        $this->output()->writeln("Private Key:\n$privateKey");
        $this->output()->writeln("Key ID:\n$keyId");
      } catch (\Exception $e) {
        $msg  = "ERROR: Unable to generate the keys, the activation code could be:\n";
        $msg .= "- Wrong,\n- Already used in the past\n";
        $msg .= "- Not active for the requested environment (stage/production)";
        throw new CommandFailedException($msg);
      }
    }
  }
}
