<?php

namespace Drupal\commerce_shipping\Plugin\Commerce\EntityTrait;

use Drupal\commerce\Attribute\CommerceEntityTrait;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\commerce\Plugin\Commerce\EntityTrait\EntityTraitBase;
use Drupal\entity\BundleFieldDefinition;

/**
 * Provides the "purchasable_entity_dimensions" trait.
 */
#[CommerceEntityTrait(
  id: 'purchasable_entity_dimensions',
  label: new TranslatableMarkup('Has dimensions'),
  entity_types: ['commerce_product_variation'],
)]
class PurchasableEntityDimensions extends EntityTraitBase {

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions(): array {
    $fields = [];
    $fields['dimensions'] = BundleFieldDefinition::create('physical_dimensions')
      ->setLabel(new TranslatableMarkup('Dimensions'))
      ->setRequired(TRUE)
      ->setDisplayOptions('form', [
        'type' => 'physical_dimensions_default',
        'weight' => 90,
      ]);

    return $fields;
  }

}
