<?php

namespace Drupal\commerce_shipping_pickup_api;

use Drupal\commerce_shipping\ProfileFieldCopy;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * If a pickup method is selected, disable "billing same as shipping".
 */
final class ProfileFieldCopyWithoutPickup extends ProfileFieldCopy {
  protected $original;

  public function __construct(AccountInterface $current_user, ProfileFieldCopy $original) {
    parent::__construct($current_user);
    $this->original = $original;
  }

  /**
   * {@inheritdoc}
   */
  public function supportsForm(array &$inline_form, FormStateInterface $form_state): bool {
    $order = self::getOrder($form_state);
    foreach ($order->get('shipments') as $shipment_item) {
      /** @var \Drupal\commerce_shipping\Entity\ShipmentInterface $shipment */
      $shipment = $shipment_item->entity;
      $plugin = $shipment->getShippingMethod()->getPlugin();
      if ($plugin && str_contains($plugin->getPluginId(), 'pickup')) {
        return FALSE;
      }
    }

    return $this->original->supportsForm($inline_form, $form_state);;
  }
}
