# Commerce Shipping Pickup BRT Italy

Provides pickup shipping service for BRT (Italy), implementing the
[commerce_shipping_pickup_api](https://www.drupal.org/project/commerce_shipping_pickup_api) framework module.

## Providers and services

- [BRT (Italy) - Fermopoint (Pickup points)](https://www.brt.it/it/brt-fermopoint/)
- [BRT (Italy) - Locker (Parcel machines)](https://www.brt.it/it/network/locker/)

## Installation

Install and enable the module through Composer:
```
composer require drupal/commerce_shipping_pickup_brt
drush en commerce_shipping_pickup_brt
```

Add the new `pickup_capable_shipping_information` pane with the label _Shipping information_
(look for the one that says _Supports pickup_ in the summary) to your checkout flow
or use the pre-built `pickup` checkout flow.

Add and set up a new shipping method in your store configuration.

There are four actual shipping methods, both _Fermopoint_ and _Lockers_ have both list-based
and map-based variants.

The list-based methods need the setting _Needs address from customer_ set in the checkout pane,
as BRT only allows us to query the pickup points relative to a specified location. First-time customers
have to provide an address, returning customers can select from their previous, stored addresses.

The map-based methods work both with and without _Needs address from customer._ If a starting address
is set or a previously stored one is selected, the map will reflect the position and show the surrounding
pickup points. If _Needs address from customer_ is not used, the map will default to the current
position of the customer, if it can be obtained, access is granted and the position is available.
If the current position cannot be established, the map will default to the default position set
among the settings of the shipping method. The last fallback, if nothing else is selected,
is the center of Rome.

The maps have a _Locate me_ button in both modes, allowing the user to relocate the map, if geolocation
is available.