(function (Drupal) {
  'use strict';

  /**
   * Behavior to initialize GLS Map Widget.
   *
   * @type {{attach: Drupal.behaviors.initGlsMapWidget.attach}}
   */
  Drupal.behaviors.initGlsMapWidget = {
    attach: function (context, settings) {
      once('init-gls-map-widget', '#gls-map-widget--map', context).forEach(function (item) {
        item.addEventListener('change', (e) => {
          let mapping = {
            'commerce-shipping-pickup--gls-name': e.detail.name,
            'commerce-shipping-pickup--gls-identifier': e.detail.id,
            'commerce-shipping-pickup--gls-country-code': e.detail.contact.countryCode,
            'commerce-shipping-pickup--gls-postal-address': e.detail.contact.address,
            'commerce-shipping-pickup--gls-locality': e.detail.contact.city,
            'commerce-shipping-pickup--gls-postal-code': e.detail.contact.postalCode,
          };

          for (const [className, value] of Object.entries(mapping)) {
            const input = document.querySelector(`.${className}`);
            if (input) {
              input.value = value;
            }
          }
        });
      });

      once('init-gls-map-widget', '.commerce-shipping-pickup--modal-opener, .commerce-shipping-pickup--gls-name', context).forEach(function (item) {
        item.addEventListener('click', (e) => {
          let el = document.getElementById('gls-map-widget--map');
          el.showModal();
          e.preventDefault();
          return false;
        });
      });
    },
  };

})(Drupal);
