# Commerce Store Dashboard

A small Drupal module that provides a dedicated dashboard view for store
administrators to view and manage them.

## INTRODUCTION

The Commerce Store Dashboard module offers a path for store administrators
to access a dashboard that can be used with Drupal's core Block Layout system to
place various blocks of information relevant to store management.

## INSTALLATION

The installation of this module is like other Drupal modules.

1. If your site is [managed via Composer](https://www.drupal.org/node/2718229),
   use Composer to download the Commerce Store Dashboard module running
   ```composer require "drupal/commerce_store_dashboard"```. Otherwise,
   copy/upload the Commerce Store Dashboard module to the modules directory
   of your Drupal installation.

2. Enable the "Commerce Store Dashboard" module in "Extend" (`/admin/modules`)

3. Set up user permissions
   (`/admin/people/permissions#module-commerce_store_dashboard`).

## CONFIGURATION

- A dedicated dashboard path is available for each store at
  `/store/{commerce_store}/dashboard`, where `{commerce_store}` is the
  store ID.

- A specific user permission "Access own store dashboard" is provided to
  control access to the dashboard page.

- Additionally, you can enable a Dashboard redirect for store administrators
  in each store type configuration at
  `/admin/commerce/config/store-types/{store_type}`.

## CONTACT

Developed and maintained by Cambrico (https://cambrico.net).

Get in touch with us for customizations and consultancy:
https://cambrico.net/contact

## MAINTAINERS

- Pedro Cambra [(pcambra)](https://drupal.org/user/122101)
- Manuel Egío [(facine)](https://drupal.org/user/1169056)
