<?php

namespace Drupal\Tests\commerce_store_dashboard\Functional;

use Drupal\commerce_store\StoreCreationTrait;
use Drupal\Tests\commerce\Functional\CommerceBrowserTestBase;
use Drupal\Tests\system\Functional\Cache\AssertPageCacheContextsAndTagsTrait;

/**
 * Base class for Commerce Store Dashboard functional tests.
 */
class CommerceStoreDashboardFunctionalTestBase extends CommerceBrowserTestBase {

  use AssertPageCacheContextsAndTagsTrait;
  use StoreCreationTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'commerce_store_dashboard',
  ];

  /**
   * {@inheritdoc}
   */
  protected function getAdministratorPermissions(): array {
    return [
      'access commerce_store overview',
      'bypass commerce_store dashboard access',
    ] + parent::getAdministratorPermissions();
  }

}
