<?php

namespace Drupal\Tests\commerce_store_dashboard\Functional;

use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\IgnoreDeprecations;

/**
 * Tests store dashboard operation alter.
 */
#[Group('commerce_store_dashboard')]
#[IgnoreDeprecations]
class CommerceStoreDashboardOperationAlterTest extends CommerceStoreDashboardFunctionalTestBase {

  /**
   * Checks that hook_entity_operation_alter() adds the dashboard operation.
   *
   * @see \Drupal\commerce_store_dashboard\Hook\CommerceStoreDashboardHooks::entityOperationAlter()
   */
  public function testEntityOperationAlter(): void {
    $this->drupalGet('/admin/commerce/config/stores');
    $this->assertSession()->linkByHrefExists($this->store->toUrl('dashboard')->toString());
    $this->assertSession()->linkExists('Dashboard');

    // Remove the bypass permission from admin and ensure they can no longer
    // access the dashboard.
    foreach ($this->adminUser->getRoles() as $role_id) {
      user_role_revoke_permissions($role_id, ['bypass commerce_store dashboard access']);
    }
    $this->drupalGet('/admin/commerce/config/stores');
    $this->assertSession()->linkByHrefNotExists($this->store->toUrl('dashboard')->toString());
    $this->assertSession()->linkNotExists('Dashboard');
  }

}
