<?php

namespace Drupal\Tests\commerce_store_dashboard\Functional;

use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\IgnoreDeprecations;

/**
 * Tests store dashboard third party settings.
 */
#[Group('commerce_store_dashboard')]
#[IgnoreDeprecations]
class CommerceStoreDashboardThirdPartySettingsTest extends CommerceStoreDashboardFunctionalTestBase {

  /**
   * Checks that third party settings are added to the store type form.
   *
   * @see \Drupal\commerce_store_dashboard\Hook\CommerceStoreDashboardHooks::formCommerceStoreTypeFormAlter()
   */
  public function testEntityThirdPartySettings(): void {
    // First time should be unchecked by default.
    $this->drupalGet($this->store->type->entity->toUrl('edit-form')->toString());
    $this->assertSession()->fieldExists('redirect_after_login');
    $this->assertSession()->checkboxNotChecked('redirect_after_login');
    $this->submitForm(['redirect_after_login' => TRUE], 'Save');

    // After submission, it should be checked.
    $this->drupalGet($this->store->type->entity->toUrl('edit-form')->toString());
    $this->assertSession()->fieldExists('redirect_after_login');
    $this->assertSession()->checkboxChecked('redirect_after_login');
    $this->submitForm(['redirect_after_login' => FALSE], 'Save');

    // After unchecking it should be unchecked again.
    $this->drupalGet($this->store->type->entity->toUrl('edit-form')->toString());
    $this->assertSession()->fieldExists('redirect_after_login');
    $this->assertSession()->checkboxNotChecked('redirect_after_login');
  }

}
