# Commerce Swish for Drupal Commerce

Integrates [Swish](https://www.swish.nu/), Sweden's leading mobile payment system, with Drupal Commerce.
This module allows merchants to accept Swish payments directly in their Drupal store.

**Developed and maintained by [Websystem.se](https://websystem.se).**


## Features & Status

The module provides a payment gateway that can be configured in three modes:

- **QR Code Mode (Stable & Production Ready):**
  Displays a QR code at checkout. This mode does not use the Swish API, so the merchant must manually verify the payment in their bank account and update the order status in Drupal Commerce.

- **Swish Sandbox (In Development):**
  A full API integration with the Swish sandbox for end-to-end testing. This mode is not yet functional.

- **Production Environment (In Development):**
  A full API integration with the live Swish network for automated payment confirmation. This mode is not yet functional.

## Requirements

- Drupal Commerce 3.x
- For API modes (Sandbox & Production):
  - **"Swish Företag"** merchant agreement with a participating bank will be required for API access.
