((Drupal, once, drupalSettings) => {
  let progressCount = 0;

  function getData(element, remoteId) {
    fetch(`/api/commerce_swish/${remoteId}`)
      .then((response) => response.json())
      .then((data) => {
        if (data.finished) {
          window.location.reload();
        }
        element.querySelector('#js-swish-payment-status').textContent =
          Drupal.t('Waiting for Swish payment') + '.'.repeat(progressCount);
        progressCount += 1;
        if (progressCount > 4) {
          progressCount = 0;
        }
      })
      .catch((error) => {
        /* eslint-disable no-console */
        console.error('Error:', error);
        /* eslint-enable no-console */
      });
  }

  once('swishStatus', '#edit-payment-process-offsite-payment').forEach(
    (element) => {
      if (drupalSettings.commerce_swish.remoteId !== undefined) {
        const { remoteId } = drupalSettings.commerce_swish;
        getData(element, remoteId);
        setInterval(() => {
          getData(element, remoteId);
        }, 1000);
      }
    },
  );
})(Drupal, once, drupalSettings);
