/**
 * @file
 * Warning if a user leaves the qr code.
 */

((Drupal) => {
  let hideWarning = false;
  Drupal.behaviors.swishWarningLeavingQrCode = {
    attach: (context) => {
      // Handle Swish link
      const hideWarningElements = context.querySelectorAll('.js-hide-warning');
      if (hideWarningElements) {
        hideWarningElements.forEach((element) => {
          element.addEventListener('click', () => {
            hideWarning = true;
          });
        });
      }

      window.onbeforeunload = () => {
        // Custom message is not supported anymore in modern browsers.
        if (hideWarning) {
          return;
        }
        return true;
      };
    },
  };
})(Drupal);
