# Commerce Swish for Drupal Commerce

Integrates [Swish](https://www.swish.nu/), Sweden's leading mobile payment system, with Drupal Commerce.
This module allows merchants to accept Swish payments directly in their Drupal store.

**Developed and maintained by [Websystem.se](https://websystem.se).**

## Features & Status

The module provides a payment gateway that can be configured in three modes:

### QR Code mode

Displays a QR code at checkout. This mode does not use the Swish API, so the merchant must manually verify the payment in their bank account and update the
order status in Drupal Commerce.

### Swish Sandbox (In Development)

Used for development where the full flow of QR code generation and payment handling is simulated, using a developer version of both Swish and BankID. Use
separate
mobile phone. Need Sandbox access at Swish

### Merchant Swish Simulator

Used for testing payment flow on Drupal site. Developer certificates are required. A few seconds after QR code is generated, Swish will ping callback to mark
payment as paid. No extra details are required, useful to test callback functionality and firewalls. Useful in development and staging sites.

### Production Environment

Full API integration with the live Swish network for automated payment confirmation. Needs certificate from Swish.

## Requirements

- Drupal Commerce 3.x
- For API mode Sandbox:
  - Developer account for Swish Sandbox.
- For API mode MSS:
  - Download certificates from https://developer.swish.nu/documentation/environments
- For API mode Production:
  - **"Swish Företag"** merchant agreement with a participating bank will be required for API access.
  - Download certificates from http://portal.swish.nu/
