((Drupal, once, drupalSettings) => {
  let progressCount = 0;

  function getData(element, orderId, remoteId) {
    fetch(`/api/commerce_swish/${orderId}/${remoteId}`)
      .then((response) => response.json())
      .then((data) => {
        if (data.finished) {
          window.location.reload();
        }
        let message =
          Drupal.t('Waiting for Swish payment') + '.'.repeat(progressCount);
        if (data.status === 'No payment found with remoteId.') {
          // Hide QR code and link
          element.querySelector('.commerce-swish-qr-code').style.display =
            'none';
          element.querySelector(
            '.commerce-swish-same-device-link',
          ).style.display = 'none';
          message = Drupal.t(
            'Payment declined, please reload page to try again.',
          );
        }
        element.querySelector('#js-swish-payment-status').textContent = message;

        progressCount += 1;
        if (progressCount > 4) {
          progressCount = 0;
        }
      })
      .catch((error) => {
        /* eslint-disable no-console */
        console.error('Error:', error);
        /* eslint-enable no-console */
      });
  }

  once('swishStatus', '#edit-payment-process-offsite-payment').forEach(
    (element) => {
      if (
        drupalSettings.commerce_swish.orderId !== undefined &&
        drupalSettings.commerce_swish.remoteId !== undefined
      ) {
        const { orderId, remoteId } = drupalSettings.commerce_swish;
        getData(element, orderId, remoteId);
        setInterval(() => {
          getData(element, orderId, remoteId);
        }, 1000);
      }
    },
  );
})(Drupal, once, drupalSettings);
