<?php

declare(strict_types=1);

namespace Drupal\commerce_swish\Controller;

use Drupal\commerce_order\Entity\Order;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Returns responses for Commerce Swish routes.
 */
final class PaymentStatusApiController extends ControllerBase {

  /**
   * Builds the response.
   */
  public function __invoke(?Order $order, ?string $remoteId): JsonResponse {
    $result = [
      'finished' => FALSE,
      'status' => '',
    ];
    if ($order === NULL) {
      $result['status'] = 'No order found.';
      return new JsonResponse($result);
    }
    if ($order->isPaid()) {
      $result['finished'] = TRUE;
      $result['status'] = 'Order Paid.';
      return new JsonResponse($result);
    }
    if ($remoteId === NULL || $remoteId === '') {
      $result['status'] = 'No remoteId found.';
      return new JsonResponse($result);
    }
    /** @var \Drupal\commerce_payment\PaymentStorageInterface $payment_storage */
    $payment_storage = $this->entityTypeManager()->getStorage('commerce_payment');
    $payment = $payment_storage->loadByRemoteId($remoteId);
    if ($payment === NULL) {
      $result['status'] = 'No payment found with remoteId.';
      return new JsonResponse($result);
    }
    if ($payment->getState()->getId() === 'completed') {
      $result['finished'] = TRUE;
      $result['status'] = 'Payment completed.';
      return new JsonResponse($result);
    }
    $result['status'] = 'Payment pending.';

    return new JsonResponse($result);
  }

}
