# Commerce USPS

Provides USPS shipping rates for Drupal Commerce.

## USPS account setup

An account must be obtained from the [USPS developer portal](https://developers.usps.com),
then an app must be added on [the USPS COP site](https://cop.usps.com/cop-navigator)
following these steps:

- Open the "My Apps" page.
- Open the "Developer Apps" tab.
- Click the "Add app" button.
- Enter "App Name".
- Enter "Description" (optional).
- Select the APIs Available (required).
- Click the "Add App" Button

## Commerce setup

1. Use [Composer](https://getcomposer.org/) to add the Commerce USPS module
   with all dependencies: `composer require drupal/commerce_usps`
2. Enable the module.
3. Go to: `/admin/commerce/config/shipping-methods/add`
4. Fill in the following details:
    - Select "USPS Domestic" or "USPS International" as the Plugin.
    - Choose "Shipping services" to define what rates to use.
    - Under the "USPS Information" section enter the "Consumer key" and "Consumer secret" from the 
      app created earlier.
    - Select either "Test" or "Live" mode.
    - Select the "Price type" under the "Rate options" section. If "Contract" is select, 
      "Account type", "Account number", and "Customer Registration ID" is required for rate 
      requests.
    - Select a default package type.
    - Fill out any of the optional options and save configuration.
    - In the USPS Options section, make sure that logging options are disabled on the production 
      site, due to security and GDPR issues.
