<?php

namespace Drupal\commerce_usps\Event;

use Drupal\commerce\EventBase;
use Drupal\commerce_shipping\Entity\ShipmentInterface;

/**
 * Rate request event for USPS.
 */
class USPSRateRequestEvent extends EventBase {

  /**
   * RateRequestEvent constructor.
   *
   * @param array $rateRequestParams
   *   The USPS rate request parameters.
   * @param \Drupal\commerce_shipping\Entity\ShipmentInterface $shipment
   *   The Commerce Shipment entity.
   */
  public function __construct(protected array $rateRequestParams, protected ShipmentInterface $shipment) {}

  /**
   * Gets the rate request object.
   */
  public function getRateRequestParams(): array {
    return $this->rateRequestParams;
  }

  /**
   * Set the rate request.
   *
   * @param array $rate_request_params
   *   The USPS rate request parameters.
   */
  public function setRateRequestParams(array $rate_request_params): void {
    $this->rateRequestParams = $rate_request_params;
  }

  /**
   * Gets the shipment.
   */
  public function getShipment(): ShipmentInterface {
    return $this->shipment;
  }

}
