<?php

namespace Drupal\commerce_usps\Plugin\Commerce\ShippingMethod;

/**
 * Provides the USPS shipping method.
 *
 * @CommerceShippingMethod(
 *  id = "usps",
 *  label = @Translation("USPS Domestic"),
 *  services = {
 *    "MEDIA_MAIL" = @translation("Media mail"),
 *    "LIBRARY_MAIL" = @translation("Library mail"),
 *    "PARCEL_SELECT" = @translation("Parcel select"),
 *    "USPS_CONNECT_LOCAL" = @translation("USPS connect local"),
 *    "USPS_CONNECT_REGIONAL" = @translation("USPS connect regional"),
 *    "USPS_CONNECT_MAIL" = @translation("USPS connect mail"),
 *    "USPS_GROUND_ADVANTAGE" = @translation("USPS ground advantage"),
 *    "USPS_GROUND_ADVANTAGE_RETURN_SERVICE" = @translation("USPS ground advantage return service"),
 *    "PRIORITY_MAIL" = @translation("Priority mail"),
 *    "PRIORITY_MAIL_EXPRESS" = @translation("Priority mail express"),
 *    "PRIORITY_MAIL_RETURN_SERVICE" = @translation("Priority mail return service"),
 *    "PRIORITY_MAIL_EXPRESS_RETURN_SERVICE" = @translation("Priority mail express return service"),
 *    "BOUND_PRINTED_MATTER" = @translation("Bound printed-matter"),
 *  }
 * )
 */
class USPSDomestic extends USPSBase {

  /**
   * {@inheritdoc}
   */
  public function getMailClass(): string {
    if ($this->configuration['rate_options']['price_type'] === 'contract'
      && $this->configuration['rate_options']['account_type'] === 'mid'
    ) {
      return 'all_returns';
    }
    return 'all_outbound';
  }

  /**
   * {@inheritdoc}
   */
  public function getFacilityTypeOptions(): array {
    return [
      'NONE' => $this->t('None'),
      'AREA_DISTRIBUTION_CENTER' => $this->t('Area Distribution Center'),
      'AUXILIARY_SERVICE_FACILITY' => $this->t('Auxiliary Service Facility'),
      'DESTINATION_DELIVERY_UNIT' => $this->t('Destination Delivery Unit'),
      'DESTINATION_NETWORK_DISTRIBUTION_CENTER' => $this->t('Destination Network Distribution Center'),
      'DESTINATION_SECTIONAL_CENTER_FACILITY' => $this->t('Destination Sectional Center Facility'),
      'DESTINATION_SERVICE_HUB' => $this->t('Destination Service Hub'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getRateIndicatorOptions(): array {
    return [
      '3D' => $this->t('3-Digit'),
      '3N' => $this->t('3-Digit Dimensional Rectangular'),
      '3R' => $this->t('3-Digit Dimensional Nonrectangular'),
      '5D' => $this->t('5-Digit'),
      'BA' => $this->t('Basic'),
      'BB' => $this->t('Mixed NDC'),
      'BM' => $this->t('NDC'),
      'C1' => $this->t('Cubic Pricing Tier 1'),
      'C2' => $this->t('Cubic Pricing Tier 2'),
      'C3' => $this->t('Cubic Pricing Tier 3'),
      'C4' => $this->t('Cubic Pricing Tier 4'),
      'C5' => $this->t('Cubic Pricing Tier 5'),
      'CP' => $this->t('Cubic Parcel'),
      'CM' => $this->t('USPS Connect Local® Mail'),
      'DC' => $this->t('NDC'),
      'DE' => $this->t('SCF'),
      'DF' => $this->t('5-Digit'),
      'DN' => $this->t('Dimensional Nonrectangular'),
      'DR' => $this->t('Dimensional Rectangular'),
      'E4' => $this->t('Priority Mail Express Flat Rate Envelope - Post Office To Addressee'),
      'E6' => $this->t('Priority Mail Express Legal Flat Rate Envelope'),
      'E7' => $this->t('Priority Mail Express Legal Flat Rate Envelope Sunday / Holiday'),
      'FA' => $this->t('Legal Flat Rate Envelope'),
      'FB' => $this->t('Medium Flat Rate Box/Large Flat Rate Bag'),
      'FE' => $this->t('Flat Rate Envelope'),
      'FP' => $this->t('Padded Flat Rate Envelope'),
      'FS' => $this->t('Small Flat Rate Box'),
      'LC' => $this->t('USPS Connect® Local Single Piece'),
      'LF' => $this->t('USPS Connect® Local Flat Rate Box'),
      'LL' => $this->t('USPS Connect® Local Large Flat Rate Bag'),
      'LO' => $this->t('USPS Connect® Local Oversized'),
      'LS' => $this->t('USPS Connect® Local Small Flat Rate Bag'),
      'NP' => $this->t('Non-Presorted'),
      'O1' => $this->t('Full Tray Box'),
      'O2' => $this->t('Half Tray Box'),
      'O3' => $this->t('EMM Tray Box'),
      'O4' => $this->t('Flat Tub Tray Box'),
      'O5' => $this->t('Surface Transported Pallet'),
      'O6' => $this->t('Full Pallet Box'),
      'O7' => $this->t('Half Pallet Box'),
      'OS' => $this->t('Oversized'),
      'P5' => $this->t('Cubic Soft Pack Tier 1'),
      'P6' => $this->t('Cubic Soft Pack Tier 2'),
      'P7' => $this->t('Cubic Soft Pack Tier 3'),
      'P8' => $this->t('Cubic Soft Pack Tier 4'),
      'P9' => $this->t('Cubic Soft Pack Tier 5'),
      'PA' => $this->t('Priority Mail Express Single Piece'),
      'PL' => $this->t('Large Flat Rate Box'),
      'PM' => $this->t('Large Flat Rate Box APO/FPO/DPO'),
      'PR' => $this->t('Presorted'),
      'Q6' => $this->t('Cubic Soft Pack Tier 6'),
      'Q7' => $this->t('Cubic Soft Pack Tier 7'),
      'Q8' => $this->t('Cubic Soft Pack Tier 8'),
      'Q9' => $this->t('Cubic Soft Pack Tier 9'),
      'Q0' => $this->t('Cubic Soft Pack Tier 10'),
      'SB' => $this->t('Small Flat Rate Bag'),
      'SN' => $this->t('SCF Dimensional Nonrectangular'),
      'SP' => $this->t('Single Piece'),
      'SR' => $this->t('SCF Dimensional Rectangular'),
    ];
  }

}
