<?php

namespace Drupal\commerce_usps\Plugin\Commerce\ShippingMethod;

/**
 * Provides the USPS international shipping method.
 *
 * @CommerceShippingMethod(
 *  id = "usps_international",
 *  label = @Translation("USPS International"),
 *  services = {
 *    "GLOBAL_EXPRESS_GUARANTEED" = @translation("Global express guaranteed"),
 *    "PRIORITY_MAIL_INTERNATIONAL" = @translation("Priority mail international"),
 *    "PRIORITY_MAIL_EXPRESS_INTERNATIONAL" = @translation("Priority mail express international"),
 *    "FIRST-CLASS_PACKAGE_INTERNATIONAL_SERVICE" = @translation("First-class package international"),
 *  }
 * )
 */
class USPSInternational extends USPSBase {

  /**
   * {@inheritdoc}
   */
  public function getMailClass(): string {
    return 'all';
  }

  /**
   * {@inheritdoc}
   */
  public function getFacilityTypeOptions(): array {
    return [
      'NONE' => $this->t('None'),
      'INTERNATIONAL_SERVICE_CENTER' => $this->t('International Service Center'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getRateIndicatorOptions(): array {
    return [
      'E4' => $this->t('Priority Mail Express Flat Rate Envelope - Post Office To Addressee'),
      'E6' => $this->t('Priority Mail Express Legal Flat Rate Envelope'),
      'EP' => $this->t('ECOMPRO Single Piece'),
      'E7' => $this->t('Priority Mail Express Legal Flat Rate Envelope Sunday / Holiday'),
      'FA' => $this->t('Legal Flat Rate Envelope'),
      'FB' => $this->t('Medium Flat Rate Box/Large Flat Rate Bag'),
      'FE' => $this->t('Flat Rate Envelope'),
      'FP' => $this->t('Padded Flat Rate Envelope'),
      'FS' => $this->t('Small Flat Rate Box'),
      'HA' => $this->t('ECOMPRO Legal Flat Rate Envelope'),
      'HB' => $this->t('ECOMPRO Medium Flat Rate Box'),
      'HE' => $this->t('ECOMPRO Flat Rate Envelope'),
      'HL' => $this->t('ECOMPRO Large Flat Rate Box'),
      'HP' => $this->t('ECOMPRO Padded Flat Rate Envelope'),
      'HS' => $this->t('ECOMPRO Small Flat Rate Box'),
      'LE' => $this->t('Single-piece parcel'),
      'PA' => $this->t('Priority Mail Express Single Piece'),
      'PL' => $this->t('Large Flat Rate Box'),
      'SP' => $this->t('Single Piece'),
    ];
  }

}
